% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob-roc_curve.R
\name{roc_curve}
\alias{roc_curve}
\alias{roc_curve.data.frame}
\alias{autoplot.roc_df}
\title{Receiver operator curve}
\usage{
roc_curve(data, ...)

\method{roc_curve}{data.frame}(data, truth, ..., options = list(),
  na_rm = TRUE)

autoplot.roc_df(object, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the \code{truth} and \code{estimate}
columns.}

\item{...}{A set of unquoted column names or one or more
\code{dplyr} selector functions to choose which variables contain the
class probabilities. If \code{truth} is binary, only 1 column should be selected.
Otherwise, there should be as many columns as factor levels of \code{truth}.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:quasiquotation]{quasiquotation} (you can unquote column
names). For \code{_vec()} functions, a \code{factor} vector.}

\item{options}{A \code{list} of named options to pass to \code{\link[pROC:roc]{pROC::roc()}}
such as \code{direction} or \code{smooth}. These options should not include \code{response},
\code{predictor}, or \code{levels}.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{object}{The \code{roc_df} data frame returned from \code{roc_curve()}.}
}
\value{
A tibble with class \code{roc_df} or \code{roc_grouped_df} having
columns \code{specificity} and \code{sensitivity}.

If an ordinary (i.e. non-smoothed) curve
is used, there is also a column for \code{.threshold}.
}
\description{
\code{roc_curve()} constructs the full ROC curve and returns a
tibble. See \code{\link[=roc_auc]{roc_auc()}} for the area under the ROC curve.
}
\details{
\code{roc_curve()} computes the sensitivity at every unique
value of the probability column (in addition to infinity and
minus infinity). If a smooth ROC curve was produced, the unique
observed values of the specificity are used to create the curve
points. In either case, this may not be efficient for large data
sets.

There is a \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}}
method for quickly visualizing the curve. This works for
binary and multiclass output, and also works with grouped data (i.e. from
resamples). See the examples.
}
\section{Multiclass}{


If a multiclass \code{truth} column is provided, a one-vs-all
approach will be taken to calculate multiple curves, one per level.
In this case, there will be an additional column, \code{.level},
identifying the "one" column in the one-vs-all calculation.
}

\section{Relevant level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result.
In \code{yardstick}, the default is to use the \emph{first} level. To
change this, a global option called \code{yardstick.event_first} is
set to \code{TRUE} when the package is loaded. This can be changed
to \code{FALSE} if the last level of the factor is considered the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\examples{
library(ggplot2)
library(dplyr)

# Two class - a tibbble is returned
roc_curve(two_class_example, truth, Class1)

# Visualize the curve using ggplot2 manually
roc_curve(two_class_example, truth, Class1) \%>\%
  ggplot(aes(x = 1 - specificity, y = sensitivity)) +
  geom_path() +
  geom_abline(lty = 3) +
  coord_equal() +
  theme_bw()

# Or use autoplot
autoplot(roc_curve(two_class_example, truth, Class1))

\dontrun{

# Multiclass one-vs-all approach
# One curve per level
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  roc_curve(obs, VF:L) \%>\%
  autoplot()

# Same as above, but will all of the resamples
hpc_cv \%>\%
  group_by(Resample) \%>\%
  roc_curve(obs, VF:L) \%>\%
  autoplot()
}

}
\seealso{
Compute the area under the ROC curve with \code{\link[=roc_auc]{roc_auc()}}.

Other curve metrics: \code{\link{gain_curve}},
  \code{\link{lift_curve}}, \code{\link{pr_curve}}
}
\author{
Max Kuhn
}
\concept{curve metrics}
