% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{as_yamlet.yam}
\alias{as_yamlet.yam}
\title{Coerce Yam To Yamlet Format}
\usage{
\method{as_yamlet}{yam}(x,
  default_keys = getOption("yamlet_default_keys", list("label",
  "guide")), ...)
}
\arguments{
\item{x}{a yam object; see \code{\link{as_yam}}}

\item{default_keys}{character: default keys for the first n anonymous members of each element}

\item{...}{ignored}
}
\value{
yamlet: a named list with default keys applied
}
\description{
Coerces yam to yamlet format. If the object
or user specifies default keys, these are applied
See \code{\link{as_yamlet.character}}.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
file
as_yamlet(as_yam(file))

}
\seealso{
Other yamlet: \code{\link{as_yamlet.character}},
  \code{\link{as_yamlet}}, \code{\link{print.yamlet}}
}
\concept{yamlet}
\keyword{internal}
