% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.predone.R
\name{grnn.predone}
\alias{grnn.predone}
\title{Calculate a predicted value of GRNN}
\usage{
grnn.predone(net, x, type = 1)
}
\arguments{
\item{net}{The GRNN object generated by grnn.fit()}

\item{x}{The vector of input predictors}

\item{type}{A scalar, 1 for euclidean distance and 2 for manhattan distance}
}
\value{
A scalar of the predicted value
}
\description{
The function \code{grnn.predone} calculates a predicted value of GRNN based on an input vector
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
for (i in seq(5)) print(grnn.predone(gnet, X[i, ]))
}
\references{
Donald Specht. (1991). A General Regression Neural Network.
}
\seealso{
\code{\link{grnn.fit}}
}
