% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion.R
\name{roc_plot}
\alias{roc_plot}
\title{ROC Plot for categorical DVs}
\usage{
roc_plot(
  xpdb,
  mapping = NULL,
  cutpoint = 1,
  group = "ID",
  type = "ca",
  title = "ROC curve @dvcol~@probcol | @run",
  subtitle = "Ofv: @ofv, Eps shrink: @epsshk",
  caption = "@dir",
  tag = NULL,
  guide = TRUE,
  facets,
  .problem,
  quiet,
  ...
)
}
\arguments{
\item{xpdb}{<\code{xp_xtras}> or <\code{xpose_data}> object}

\item{mapping}{\code{ggplot2} style mapping}

\item{cutpoint}{<\code{numeric}> Of defined probabilities, which one to
use in plots.}

\item{group}{Variable by which to group points or text}

\item{type}{See Details.}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{guide}{Include unity line?}

\item{facets}{Additional facets}

\item{.problem}{Problem number}

\item{quiet}{Silence extra debugging output}

\item{...}{Any additional aesthetics.}
}
\value{
A desired plot
}
\description{
ROC Plot for categorical DVs
}
\details{
For type-based customization of plots:
\itemize{
\item \code{c} ROC curve (using \code{geom_path})
\item \code{k} Key points on ROC curve (where on curve the
threshold is \code{thres_fixed}) (using \code{geom_point})
\item \code{p} ROC space points (using \code{geom_point})
\item \code{t} ROC space text (using \code{geom_text})
\item \code{a} AUC in bottom right (using \code{geom_label})
}
}
\examples{
# Note these examples are similar to catdv_vs_dvprobs

\dontrun{
# Test M3 model
pkpd_m3 \%>\%
  # Need to ensure var types are set
  set_var_types(catdv=BLQ,dvprobs=LIKE) \%>\%
  # Set probs
  set_dv_probs(1, 1~LIKE, .dv_var = BLQ) \%>\%
  # Optional, but useful to set levels
  set_var_levels(1, BLQ = lvl_bin()) \%>\%
  # Generate typical ROC curve
  roc_plot()

# Test categorical model
vismo_xpdb <- vismo_pomod  \%>\%
  set_var_types(.problem=1, catdv=DV, dvprobs=matches("^P\\\\d+$")) \%>\%
  set_dv_probs(.problem=1, 0~P0,1~P1,ge(2)~P23)

# Various cutpoints (note axes labels and texts)
vismo_xpdb \%>\%
  roc_plot(type = "p") # space plot
vismo_xpdb \%>\%
  roc_plot(cutpoint=2, type = "cak") # with area and key point
vismo_xpdb \%>\%
  roc_plot(cutpoint=3, type = "cak")

# alternative model example
vismo_xpdb2  <- vismo_dtmm   \%>\%
  set_var_types(.problem=1, catdv=DV, dvprobs=matches("^P\\\\d+$")) \%>\%
  set_dv_probs(.problem=1, 0~P0,1~P1,ge(2)~P23)
vismo_xpdb2 \%>\%
  roc_plot(cutpoint=2, type = "cak")
}

}
\seealso{
\code{\link[=catdv_vs_dvprobs]{catdv_vs_dvprobs()}}
}
