% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_shk}
\alias{get_shk}
\title{Get shrinkage estimates from model summary}
\usage{
get_shk(xpdb, wh = "eta", .problem = NULL, .subprob = NULL, .method = NULL)
}
\arguments{
\item{xpdb}{An \code{xpose_data} object.}

\item{wh}{The shrinkage to extract (\code{"eta"} or \code{"eps"})}

\item{.problem}{Problem number to use. Uses the xpose default if not provided.}

\item{.subprob}{<\code{numeric}> Subproblem number to use. Uses the xpose default if not provided.}

\item{.method}{<\code{character}> Method to use. Uses the xpose default if not provided.}
}
\value{
A numeric vector of shrinkage estimates.
}
\description{
This function parses shrinkages as they are currently
presented in \code{\link[xpose]{get_summary}}, so it
is dependent on the current implementation of that function.
}
\examples{
data("xpdb_ex_pk", package = "xpose")

# eta Shrinkage
get_shk(xpdb_ex_pk)

# epsilon Shrinkage
get_shk(xpdb_ex_pk, wh = "eps")


}
