% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_pages.R
\name{n_pages}
\alias{n_pages}
\alias{n_pages_exiftool}
\alias{n_pages_qpdf}
\alias{n_pages_pdftk}
\alias{n_pages_gs}
\title{Get number of pages in a document}
\usage{
n_pages(filename, use_names = TRUE)

n_pages_exiftool(filename, use_names = TRUE)

n_pages_qpdf(filename, use_names = TRUE)

n_pages_pdftk(filename, use_names = TRUE)

n_pages_gs(filename, use_names = TRUE)
}
\arguments{
\item{filename}{Character vector of filenames.}

\item{use_names}{If \code{TRUE} (default) use \code{filename} as the names of the result.}
}
\value{
An integer vector of number of pages within each file.
}
\description{
\code{n_pages()} returns the number of pages in the (pdf) file(s).
}
\details{
\code{n_pages()} will try to use the following helper functions in the following order:
\enumerate{
\item \code{n_pages_qpdf()} which wraps \code{\link[qpdf:qpdf]{qpdf::pdf_length()}}
\item \code{n_pages_exiftool()} which wraps \code{exiftool} command-line tool
\item \code{n_pages_pdftk()} which wraps \code{pdftk} command-line tool
\item \code{n_pages_gs()} which wraps \code{ghostscript} command-line tool
}
}
\examples{
if (supports_n_pages() && require("grid", quietly = TRUE)) {
  f <- tempfile(fileext = ".pdf")
  pdf(f, onefile = TRUE)
  grid.text("Page 1")
  grid.newpage()
  grid.text("Page 2")
  invisible(dev.off())
  print(n_pages(f))
  unlink(f)
}
}
\seealso{
\code{\link[=supports_n_pages]{supports_n_pages()}} detects support for this feature.
}
