% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml.R
\name{yaml_load}
\alias{yaml_load}
\title{Read YAML data}
\usage{
yaml_load(
  x,
  ...,
  handlers = NULL,
  envir = parent.frame(),
  use_yaml = loadable("yaml")
)
}
\arguments{
\item{x}{A character vector of YAML data.}

\item{..., handlers}{Arguments to be passed to \code{\link[yaml:yaml.load]{yaml::yaml.load()}}.}

\item{envir}{The environment in which R expressions in YAML are evaluated. To
disable the evaluation, use \code{envir = FALSE}.}

\item{use_yaml}{Whether to use the \pkg{yaml} package.}
}
\value{
An R object (typically a list).
}
\description{
If the \pkg{yaml} package is installed, use \code{\link[yaml:yaml.load]{yaml::yaml.load()}} to read the
data. If not, use a simple parser instead, which only supports a limited
number of data types (see \dQuote{Examples}). In particular, it does not
support values that span across multiple lines (such as multi-line text).
}
\note{
R expressions in YAML will be returned as \link{expression}s when they are
not evaluated. This is different with \code{\link[yaml:yaml.load]{yaml::yaml.load()}}, which returns
character strings for expressions.
}
\examples{
# test the simple parser without using the yaml package
read_yaml = function(...) xfun::yaml_load(..., use_yaml = FALSE)
read_yaml("a: 1")
read_yaml("a: 1\nb: \"foo\"\nc: null")
read_yaml("a:\n  b: false\n  c: true\n  d: 1.234\ne: bar")
read_yaml("a: !expr paste(1:10, collapse = \", \")")
read_yaml("a: [1, 3, 4, 2]")
read_yaml("a: [1, \"abc\", 4, 2]")
read_yaml("a: [\"foo\", \"bar\"]")
read_yaml("a: [true, false, true]")
# the other form of array is not supported
read_yaml("a:\n  - b\n  - c")
# and you must use the yaml package
if (loadable("yaml")) yaml_load("a:\n  - b\n  - c")
}
