% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/share_again.R
\name{embed_xaringan}
\alias{embed_xaringan}
\title{Embed a xaringan presentation in a web page}
\usage{
embed_xaringan(
  url,
  ratio = "16:9",
  border = "2px solid currentColor",
  max_width = NULL,
  margin = "1em auto",
  style = NULL
)
}
\arguments{
\item{url}{The URL or path to the presentation to embed.}

\item{ratio}{The ratio of the presentation, either as \code{"width:height"} or
\code{width/height}, e.g. \code{"16:9"} or \code{1.7777}.}

\item{border}{The border style of the embedded \verb{<iframe>}. For no border, use
\code{"none"}.}

\item{max_width}{The max width of the \verb{<iframe>}, in a valid CSS units.}

\item{margin}{The margin placed around the embedded \verb{<iframe>}.}

\item{style}{Additional CSS \code{style} property value pairs, e.g.
\code{c("padding-left: 1em", "padding-right: 1em")}.}
}
\value{
An \code{htmltools::tagList()} with the HTML dependencies required for
\strong{share again}.
}
\description{
Embed xaringan slides in any HTML web page, such as a blogdown page or an
R Markdown website. The presentation is embedded in a responsive aspect ratio
container for seamless integration with your web page. This feature works
best when combined with \code{\link[=use_share_again]{use_share_again()}}, but \code{embed_xaringan()} can be
used for any xaringan presentation.
}
\examples{
# In your slides call
use_share_again()

}
\seealso{
\code{\link[=use_share_again]{use_share_again()}}
}
