% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_manhattan}
\alias{xQTLvisual_manhattan}
\title{Advanced CM plot of 11}
\usage{
xQTLvisual_manhattan(gwasDF, pvalue_cutoff = 1e-04, num_snp_selected = 2000)
}
\arguments{
\item{gwasDF}{A data.frame of summary statistics data, including four cols arranged in the following order: SNP name, chomosome, position, p-value.}

\item{pvalue_cutoff}{Default: 1e-4. The Manhattan plot is a helpful tool for visualizing genome-wide association study results. However, when there are a large number of SNPs, the plot can become difficult to render and generate a large file size. This is due to the stacking of non-significant SNPs at the bottom of the plot. To address this issue, we can choose to filter out some of the non-significant SNPs or randomly select a subset of them to plot. This will improve the readability of the plot and reduce the file size.}

\item{num_snp_selected}{Default: 2000. Number of SNPs randomly selected for each chromosome.}
}
\value{
A pdf format figure.
}
\description{
Advanced CM plot of 11
}
\examples{
\donttest{
gwasDF <- data.table::fread(
      "https://master.dl.sourceforge.net/project/exampledata/gwas/AD/gwasChr6Sub.txt")
xQTLvisual_manhattan(gwasDF[,.(rsid, chr, position,P)])
}
}
