% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.connected.R
\name{is.connected}
\alias{is.connected}
\title{Tests if a graph is connected}
\usage{
is.connected(adj)
}
\arguments{
\item{adj}{An adjacency matrix. Must be a numeric matrix with non-negative entries.}
}
\value{
\code{is.connected} returns \code{TRUE} or \code{FALSE} depending on whether
the graph represented in \code{adj} is a connected graph.
}
\description{
Tests if a graph represented by an adjacency matrix is connected.
}
\details{
Idea by Ed Scheinerman, circa 2006. 
Source: http://www.ams.jhu.edu/~ers/matgraph/; routine: 
matgraph/@graph/isconnected.m
}
\examples{
g1<-matrix(c(0,0,0,1,1,0,0,0,0,1,0,0,0,0,1,0),4,4)
is.connected(g1)
g2<-matrix(c(0,1,0,0,1,0,0,0,0,0,0,1,0,0,1,0),4,4)
is.connected(g2)

}
\seealso{
\code{\link{cluseigen}}, \code{\link{clust}}, \code{browseVignettes("wsyn")}
}
\author{
Lei Zhao, \email{lei.zhao@cau.edu.cn}
}
