% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/namedMapBuilder.R
\name{named_map_builder}
\alias{named_map_builder}
\alias{:=}
\alias{\%:=\%}
\title{Named map builder.}
\usage{
named_map_builder(targets, values)

`:=`(targets, values)

targets \%:=\% values
}
\arguments{
\item{targets}{names to set.}

\item{values}{values to assign to names (and return).}
}
\value{
values with names set.
}
\description{
Set names of right-argument to be left-argument, and return right argument.
Called from \code{:=} operator.
}
\examples{


c('a' := '4', 'b' := '5')
# equivalent to: c(a = '4', b = '5')

c('a', 'b') := c('1', '2')
# equivalent to: c(a = '1', b = '2')

# the important example
name <- 'a'
name := '5'
# equivalent to: c('a' = '5')

}
\seealso{
\code{\link{lambda}}, \code{\link{defineLambda}}, \code{\link{makeFunction_se}}
}
