% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpipe.R
\name{apply_right_S4}
\alias{apply_right_S4}
\title{S4 dispatch method for apply_right.}
\usage{
apply_right_S4(pipe_left_arg, pipe_right_arg, pipe_environment,
  left_arg_name, pipe_string, right_arg_name)
}
\arguments{
\item{pipe_left_arg}{left argument}

\item{pipe_right_arg}{substitute(pipe_right_arg) argument}

\item{pipe_environment}{environment to evaluate in}

\item{left_arg_name}{name, if not NULL name of left argument.}

\item{pipe_string}{character, name of pipe operator.}

\item{right_arg_name}{name, if not NULL name of right argument.}
}
\value{
result
}
\description{
Intended to be generic on first two arguments.
}
\examples{

a <- data.frame(x = 1)
b <- data.frame(x = 2)

# a \%.>\% b # will (intentionally) throw

setMethod(
  "apply_right_S4",
  signature("data.frame", "data.frame"),
  function(pipe_left_arg,
           pipe_right_arg,
           pipe_environment,
           left_arg_name,
           pipe_string,
           right_arg_name) {
    rbind(pipe_left_arg, pipe_right_arg)
  })


a \%.>\% b # should equal data.frame(x = c(1, 2))

}
\seealso{
\code{\link{apply_left}}, \code{\link{apply_right}}
}
