% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listBatchReplace.R
\name{listBatchReplace}
\alias{listBatchReplace}
\title{Replacements in list}
\usage{
listBatchReplace(
  lst,
  searchValue,
  replaceBy,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{lst}{input-list to be used for replacing}

\item{searchValue}{(character, length=1)}

\item{replaceBy}{(character, length=1)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a corrected list
}
\description{
\code{listBatchReplace} replaces in list \code{lst} all entries with value \code{searchValue} by \code{replaceBy}
}
\examples{
lst1 <- list(aa=1:4, bb=c("abc","efg","abhh","effge"), cc=c("abdc","efg"))
listBatchReplace(lst1, search="efg", repl="EFG", sil=FALSE)
}
\seealso{
basic replacement \code{sub} in \code{\link[base]{grep}}
}
