% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_build.R
\name{wflow_build}
\alias{wflow_build}
\title{Build the site}
\usage{
wflow_build(files = NULL, make = is.null(files), update = FALSE,
  republish = FALSE, view = interactive(), clean_fig_files = FALSE,
  delete_cache = FALSE, seed = 12345, log_dir = NULL,
  verbose = FALSE, local = FALSE, dry_run = FALSE, project = ".")
}
\arguments{
\item{files}{character (default: NULL). Files to build. Only allows files in
the analysis directory with the extension Rmd or rmd. If \code{files} is
\code{NULL}, the default behavior is to build all outdated files (see
argument \code{make} below). Supports file
\href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.
The files are always built in the order they are listed.}

\item{make}{logical (default: \code{is.null(files)}). When \code{make =
TRUE}, build any files that have been modified more recently than their
corresponding HTML files (inspired by
\href{https://en.wikipedia.org/wiki/Make_(software)}{Make}). This is the
default action if no files are specified.}

\item{update}{logical (default: FALSE). Build any files that have been
committed more recently than their corresponding HTML files (and do not
have any unstaged or staged changes). This ensures that the commit version
ID inserted into the HTML corresponds to the exact version of the source
file that was used to produce it.}

\item{republish}{logical (default: FALSE). Build all published R Markdown
files (that do not have any unstaged or staged changes). Useful for
site-wide changes like updating the theme, navigation bar, or any other
setting in \code{_site.yml}.}

\item{view}{logical (default: \code{\link{interactive}}). View the website
with \code{\link{wflow_view}} after building files. If only one file is
built, it is opened. If more than one file is built, the main index page is
opened. Not applicable if no files are built or if \code{dry_run = TRUE}.}

\item{clean_fig_files}{logical (default: FALSE). Delete existing figure files
for each R Markdown file prior to building it. This ensures that only
relevant figure files are saved. As you develop an analysis, it is easy to
generate lots of unused plots due to changes in the number of code chunks
and their names. However, if you are caching chunks during code
development, this could cause figures to disappear. Note that
\code{\link{wflow_publish}} uses \code{clean_fig_files = TRUE} to ensure
the results can be reproduced.}

\item{delete_cache}{logical (default: FALSE). Delete the cache directory (if
it exists) for each R Markdown file prior to building it.}

\item{seed}{numeric (default: 12345). The seed to set before building each
file. Passed to \code{\link{set.seed}}. \bold{DEPRECATED:} The seed set
here has no effect if you are using \code{\link{wflow_html}} as the output
format defined in \code{_site.yml}. This argument is for backwards
compatibility with previous versions of workflowr.}

\item{log_dir}{character (default: NULL). The directory to save log files
from building files. It will be created if necessary and ignored if
\code{local = TRUE}. The default is to use a directory named
\code{workflowr} in \code{\link{tempdir}}.}

\item{verbose}{logical (default: FALSE). Display the build log directly in
the R console as each file is built. This is useful for monitoring
long-running code chunks.}

\item{local}{logical (default: FALSE). Build files locally in the R console.
This should only be used for debugging purposes. The default is to build
each file in its own separate fresh R process to ensure each file is
reproducible in isolation.}

\item{dry_run}{logical (default: FALSE). List the files to be built, without
building them.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
An object of class \code{wflow_build}, which is a list with the
  following elements:

 \itemize{

   \item \bold{files}: The input argument \code{files}

   \item \bold{make}: The input argument \code{make}

   \item \bold{update}: The input argument \code{update}

   \item \bold{republish}: The input argument \code{republish}

   \item \bold{view}: The input argument \code{view}

   \item \bold{clean_fig_files}: The input argument \code{clean_fig_files}

   \item \bold{delete_cache}: The input argument \code{delete_cache}

   \item \bold{seed}: The input argument \code{seed}

   \item \bold{log_dir}: The directory where the log files were saved

   \item \bold{verbose}: The input argument \code{verbose}

   \item \bold{local}: The input argument \code{local}

   \item \bold{dry_run}: The input argument \code{dry_run}

   \item \bold{built}: The relative paths to the built R Markdown files

   \item \bold{html}: The relative paths to the corresponding HTML files

 }
}
\description{
\code{wflow_build} builds the website from the files in the analysis
directory. This is intended to be used when developing your code to preview
the changes. When you are ready to commit the files, use
\code{\link{wflow_publish}}.
}
\details{
\code{wflow_build} has multiple, non-mutually exclusive options for deciding
which files to build. In other words, if multiple options are set to
\code{TRUE}, the union of all files will be built. The argument \code{make}
is the most useful for interactively performing your analysis. The other
options are more useful when you are ready to publish specific files with
\code{\link{wflow_publish}} (which passes these arguments to
\code{wflow_build}).

\itemize{

\item Files specified via the argument \code{files} are always built.

\item If \code{make = TRUE}, all files which have been modified more recently
than their corresponding HTML files will be built.

\item If \code{update = TRUE}, all previously published files which have been
committed more recently than their corresponding HTML files will be built.
However, files which currently have staged or unstaged changes will be
ignored.

\item If \code{republish = TRUE}, all published files will be rebuilt.
However, files which currently have staged or unstaged changes will be
ignored.

}

Under the hood, \code{wflow_build} is a wrapper for
\code{\link[rmarkdown]{render_site}} from the package \link{rmarkdown}.
}
\examples{
\dontrun{

# Build any files which have been modified
wflow_build() # equivalent to wflow_build(make = TRUE)
# Build a single file
wflow_build("file.Rmd")
# Build multiple files
wflow_build(c("file1.Rmd", "file2.Rmd"))
# Build multiple files using a file glob
wflow_build("file*.Rmd")
# Build every published file
wflow_build(republish = TRUE)
# Build file.Rmd and any files which have been modified
wflow_build("file.Rmd", make = TRUE)
}

}
\seealso{
\code{\link{wflow_publish}}
}
