% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_infs.R
\name{row_infs}
\alias{row_infs}
\alias{row_infs.matrix}
\alias{row_infs.data.frame}
\title{Conditions related to infinite values}
\usage{
row_infs(.data, match_type = "none", ...)

\method{row_infs}{matrix}(.data, match_type = "none", ...)

\method{row_infs}{data.frame}(.data, match_type = "none", ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{match_type}{One of ("all", "any", "none", "which_first", "count"). Possibly abbreviated.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{output_class}}{One of ("vector", "list", "data.frame", "matrix"), possibly abbreviated.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
  }}
}
\description{
Conditions related to infinite values
}
\examples{

# consistency with R with respect to NA/NaN
row_infs(data.frame(NaN, NA_real_, NA_complex_), "none")

# complex can also be infinite
row_infs(data.frame(Inf, -Inf, as.complex(Inf), as.complex(-Inf)), "all")

}
