% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_in.R
\name{row_in}
\alias{row_in}
\alias{row_in.matrix}
\alias{row_in.data.frame}
\title{Check if a row's columns' values are present in a set of known values}
\usage{
row_in(.data, match_type = "none", sets = list(), negate = FALSE, ...)

\method{row_in}{matrix}(.data, match_type = "none", sets = list(), negate = FALSE, ...)

\method{row_in}{data.frame}(.data, match_type = "none", sets = list(), negate = FALSE, ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{match_type}{One of ("all", "any", "none", "which_first", "count"). Possibly abbreviated.}

\item{sets}{The list of sets to compare against. See details.}

\item{negate}{Logical. If \code{TRUE}, values that are \emph{not} in the \code{sets} are sought.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{output_class}}{One of ("vector", "list", "data.frame", "matrix"), possibly abbreviated.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
    \item{\code{factor_mode}}{One of ("character", "integer"), possibly abbreviated. If a column is a
factor, this determines whether the operation uses its internal integer values, or the
character values from its levels.}
  }}
}
\description{
Check if a row's columns' values are present in a set of known values
}
\details{
The \code{sets} are recycled in order to match the number of columns in \code{.data}.

Type promotion/conversion will follow normal R rules.
}
\note{
Note that string comparison follows C++ rules.
}
\examples{

mat <- matrix(sample(letters, 10), nrow = 5L, ncol = 2L)

# count how many columns are in a chosen subset
row_in(mat, "count", list(c("a", "b")))

# careful if complex numbers are involved
row_in(data.frame(-1 + 0i, 1/3 + 0i), "all", list(-1L, 1/3))
row_in(data.frame(-1 + 1i, 1/3 - 1i), "none", list(-1L, 1/3))

}
