% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_compare.R
\name{row_compare}
\alias{row_compare}
\alias{row_compare.matrix}
\alias{row_compare.data.frame}
\title{Check if a row's columns fulfill a given comparison}
\usage{
row_compare(.data, match_type = "none", operator = "==", values = 0L, ...)

\method{row_compare}{matrix}(.data, match_type = "none", operator = "==", values = 0L, ...)

\method{row_compare}{data.frame}(.data, match_type = "none", operator = "==", values = 0L, ...)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{match_type}{One of ("all", "any", "none", "which_first", "count"). Possibly abbreviated.}

\item{operator}{A character indicating the comparison operator. See details.}

\item{values}{The value or list of values to compare against. See details.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{output_class}}{One of ("vector", "list", "data.frame", "matrix"), possibly abbreviated.}
    \item{\code{na_action}}{One of ("exclude", "pass"), possibly abbreviated. See \link[stats:na.pass]{stats::na.pass} for
semantics.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
    \item{\code{factor_mode}}{One of ("character", "integer"), possibly abbreviated. If a column is a
factor, this determines whether the operation uses its internal integer values, or the
character values from its levels.}
  }}
}
\description{
For each desired row, check if all/any/none of the columns fulfill a given comparison, return the
index of the first column that fulfills the comparison, or the number of columns that do.
}
\details{
The character in \code{operator} should match one of the \link[base:Comparison]{base::Comparison} operators. You can also
pass "is", which is an alias for "==", but might convey code semantics better in case \code{values}
contain \code{NA} or \code{Inf}.

If \code{values} is not a list, it will be coerced to one with \code{\link[base:as.list]{base::as.list()}}. Each element in the
list must have length equal to 1. The values are recycled in order to match the number of columns
in \code{.data}.

Type promotion/conversion will follow normal R rules.

The \code{na_action} from \code{\link[=op_ctrl]{op_ctrl()}} is only relevant when a value from \code{values} is \emph{not} \code{NA}.
}
\note{
Note that string comparison follows C++ rules.
}
\examples{

row_compare(data.frame(0L, 1.0, "0", TRUE, 0+0i),
            "all", "==", values = list(0L, 1L))

row_compare(data.frame(NA_integer_, NA_real_, NA_character_, NA, NA_complex_),
            "all", "is", values = NA)

}
