% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readerFuncs.R
\name{read_cd3}
\alias{read_cd3}
\title{A function to read .CD3 files}
\usage{
read_cd3(station, loc_WinFapFiles = getwd())
}
\arguments{
\item{station}{the NRFA station number(s) for which the .CD3 file (names \code{station.CD3}) should be read}

\item{loc_WinFapFiles}{the file.path of the WINFAP files, i.e. the location in which the
\code{station.CD3} file can be found. Default is the working directory}
}
\value{
a data.frame with information on the catchment descriptors for the station
}
\description{
The function reads .CD3 files once these are in a local folder: these files contain information on the gauging station and on the catchment upstream the station.
}
\seealso{
Information on the .CD3 files and river flow gauging in the UK can be found at the National River Flow Archive website \url{https://nrfa.ceh.ac.uk}.
Specific information on the catchment descriptors can be found at \url{https://nrfa.ceh.ac.uk/feh-catchment-descriptors}
}
