% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turbine_influences.R
\name{turbine_influences}
\alias{turbine_influences}
\title{Find potentially influencing turbines}
\usage{
turbine_influences(t, wnkl, dist, polYgon, dirct, plotAngles = FALSE)
}
\arguments{
\item{t}{A data.frame of the current individual with X and Y coordinates}

\item{wnkl}{The angle from which wake influences are considered to be 
negligible}

\item{dist}{A numeric value indicating the distance, after which the wake
effects are considered to be eliminated.}

\item{polYgon}{A shapefile representing the considered area}

\item{dirct}{A numeric value indicating the current wind direction}

\item{plotAngles}{A logical variable, which is used to plot the distances and
angles. Default is \code{FALSE}}
}
\value{
Returns a list of all individuals of the current generation which
  could potentially influence other turbines. List includes the relevant
  coordinates, the distances and angles in between and assigns the Point ID.
}
\description{
Find all turbines that could potentially influence another
  turbine and save them to a list.
}
\examples{
## Exemplary input Polygon with 2km x 2km:
library(sf)

Polygon1 <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(0, 0, 2000, 2000, 0),
    c(0, 2000, 2000, 0, 0)))),
  crs = 3035
))

t <- st_coordinates(st_sample(Polygon1, 10))
wnkl <- 20
dist <- 100000
dirct <- 0

res <- turbine_influences(t, wnkl, dist, Polygon1, dirct, plotAngles = TRUE)

}
\seealso{
Other Wind Energy Calculation Functions: 
\code{\link{barometric_height}()},
\code{\link{calculate_energy}()},
\code{\link{get_dist_angles}()}
}
\concept{Wind Energy Calculation Functions}
