% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapGA.R
\name{heatmapGA}
\alias{heatmapGA}
\title{Plot heatmap of fit grid cells}
\usage{
heatmapGA(result, si = 2, idistw)
}
\arguments{
\item{result}{The output matrix of \code{\link{windfarmGA}} or
\code{\link{genAlgo}}, which has stored all relevant information}

\item{si}{A numeric value that is used for the sizing of the
resolution of the heatmap. Default is 2}

\item{idistw}{The inverse distance weighting power. Default is the
rotor radius from the 'result' values}
}
\value{
Invisibly returns a list with the result of the inverse distance
weighting and an aggregated dataframe of all grid cells
}
\description{
Plot a heatmap of the selected grid cells. Green grid
cells have been selected more often than red grid cells.
}
\examples{
\donttest{
## Add some data examples from the package
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))

## Plot the results of a hexagonal grid optimization
result <- resulthex
heatmapGA(result)

## Plot the heatmap with different settings
heatmapGA(result, si = 6, idistw = 2)
heatmapGA(result, si = 6, idistw = 100)
heatmapGA(result, si = 20, idistw = 10)
}
}
\author{
Sebastian Gatscha
}
