% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{tobias_parser}
\alias{tobias_parser}
\title{TOBIAS TFBS table to clarion parser}
\usage{
tobias_parser(input, output, filter_columns = NULL,
  filter_pattern = NULL, config = system.file("extdata",
  "tobias_config.json", package = "wilson"), omit_NA = FALSE,
  condition_names = NULL, condition_pattern = "_bound$",
  in_field_delimiter = ",", dec = ".", ...)
}
\arguments{
\item{input}{Path to input table}

\item{output}{Output path.}

\item{filter_columns}{Either a vector of columnnames or a file containing one columnname per row.}

\item{filter_pattern}{Keep columns matching the given pattern. Uses parameter filter_columns for matching if set. In the case of no matches a warning will be issued and all columns will be used.}

\item{config}{Json file containing metadata information for all columns. Will use first occurence for duplicate column names.}

\item{omit_NA}{Logical whether all rows containing NA should be removed.}

\item{condition_names}{Vector of condition names. Default = NULL. Used to classify columns not provided in config.}

\item{condition_pattern}{Used to identify condition names by matching and removing given pattern with \code{\link[base]{grep}}. Ignored when condition_names is set.}

\item{in_field_delimiter}{Delimiter for multi value fields. Default = ','.}

\item{dec}{Decimal separator. Used in file reading and writing.}

\item{...}{Used as header information.}
}
\description{
Click \href{https://github.molgen.mpg.de/loosolab/TOBIAS}{here} for more information about TOBIAS.
}
\details{
During conversion the parser will try to use the given config (if provided) to create the \href{https://github.molgen.mpg.de/loosolab/wilson-apps/wiki/CLARION-Format}{Clarion} metadata. In the case of insufficient config information it will try to approximate by referencing condition names issuing warnings in the process.

As the format requires an unique id the parser will create one if necessary.

Factor grouping (metadata factor columns) is currently not implemented!
}
