% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{searchData}
\alias{searchData}
\title{Function to search data for selection}
\usage{
searchData(input, choices, options = c("=", "<", ">"),
  min. = min(choices, na.rm = TRUE), max. = max(choices, na.rm = TRUE))
}
\arguments{
\item{input}{Vector length one (single) or two (ranged) containing numeric values for selection.}

\item{choices}{Vector on which input values are applied.}

\item{options}{Vector on how the input and choices should be compared. It can contain: single = c("=", "<", ">") or ranged = c("inner", "outer").}

\item{min.}{Minimum value that can be selected on slider (defaults to min(choices)).}

\item{max.}{Maximum value that can be selected on slider (defaults to max(choices)).}
}
\value{
Returns a logical vector with the length of choices, where every matched position is TRUE.
}
\description{
Function to search data for selection
}
