% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_burn_streams_at_roads}
\alias{wbt_burn_streams_at_roads}
\title{Burn streams at roads}
\usage{
wbt_burn_streams_at_roads(
  dem,
  streams,
  roads,
  output,
  width = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster digital elevation model (DEM) file.}

\item{streams}{Input vector streams file.}

\item{roads}{Input vector roads file.}

\item{output}{Output raster file.}

\item{width}{Maximum road embankment width, in map units.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Burns-in streams at the sites of road embankments.
}
\keyword{HydrologicalAnalysis}
