% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_embankment_mapping}
\alias{wbt_embankment_mapping}
\title{Embankment mapping}
\usage{
wbt_embankment_mapping(
  dem,
  road_vec,
  output,
  search_dist = 2.5,
  min_road_width = 6,
  typical_width = 30,
  max_height = 2,
  max_width = 60,
  max_increment = 0.05,
  spillout_slope = 4,
  remove_embankments = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{road_vec}{Input vector polygons file.}

\item{output}{Output raster file.}

\item{search_dist}{Search distance used to reposition transportation vectors onto road embankments (in map units).}

\item{min_road_width}{Minimum road width; this is the width of the paved road surface (in map units).}

\item{typical_width}{Typical embankment width; this is the maximum width of an embankment with roadside ditches (in map units).}

\item{max_height}{Typical embankment maximum height; this is the height a typical embankment with roadside ditches (in map units).}

\item{max_width}{Maximum embankment width, typically where embankments traverse steep-sided valleys (in map units).}

\item{max_increment}{Maximum upwards increment between neighbouring cells on an embankment (in elevation units).}

\item{spillout_slope}{Spillout slope (in degrees).}

\item{remove_embankments}{Optional flag indicating whether to output a DEM with embankments removed (true) or an embankment raster map (false).}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is False, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}
}
\value{
Returns the tool text outputs.
}
\description{
Maps and/or removes road embankments from an input fine-resolution DEM.
}
