% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whep_inputs.R
\docType{data}
\name{whep_inputs}
\alias{whep_inputs}
\title{External inputs}
\format{
A tibble where each row corresponds to one external input dataset.
It contains the following columns:
\itemize{
\item \code{alias}: An internal name used to refer to this dataset, which is the
expected name when trying to get the dataset with \code{whep_read_file()}.
\item \code{board_url}: The public static URL where the data is found, following
the concept of a \emph{board} from the
\href{https://pins.rstudio.com/index.html}{\code{pins}} package, which is what we
use for storing these input datasets.
\item \code{version}: The specific version of the dataset, as defined by the \code{pins}
package. The version is a string similar to \code{"20250714T123343Z-114b5"}.
This version is the one used by default if no \code{version} is specified when
calling \code{whep_read_file()}. If you want to use a different one, you can
find the available versions of a file by using \code{whep_list_file_versions()}.
}
}
\source{
Created by the package authors.
}
\usage{
whep_inputs
}
\description{
The information needed for accessing external datasets used as inputs
in our modeling.
}
\keyword{datasets}
