% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audience_networks.R
\name{audience_incidence}
\alias{audience_incidence}
\title{Create incidence matrix for audience-outlet network}
\usage{
audience_incidence(wt, cutoff = 3)
}
\arguments{
\item{wt}{webtrack data object}

\item{cutoff}{visits below this cutoff will not be considered as a visit}
}
\value{
incidence audience-outlet network
}
\description{
Create incidence matrix for audience-outlet network
}
\details{
The incidence matrix is a matrix A with entries  \code{A[i,j]=1} if panelist i visited outlet j at least once.
}
\examples{
data("test_data")
wt <- as.wt_dt(test_data)
wt <- add_duration(wt)
wt <- extract_domain(wt)
audience_incidence(wt)
}
\seealso{
to create audience networks see \link{audience_network}
}
