% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{aggregate_duration}
\alias{aggregate_duration}
\title{Aggregate duration of consecutive visits to a website}
\usage{
aggregate_duration(wt, keep = FALSE)
}
\arguments{
\item{wt}{webtrack data object}

\item{keep}{logical. if intermediary columns should be kept or not. defaults to FALSE}
}
\value{
webtrack data.table with the same columns as wt with updated duration
}
\description{
Aggregate duration of consecutive visits to a website
}
\examples{
data("test_data")
wt <- as.wt_dt(test_data)
wt <- add_duration(wt)
wt <- extract_domain(wt)
# the following step can take longer
wt <- wt[1:100,]
aggregate_duration(wt)
}
