% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestPattern.R
\docType{data}
\name{UriPattern}
\alias{UriPattern}
\title{UriPattern}
\arguments{
\item{pattern}{(character) a uri, as a character string. if scheme
is missing, it is added (we assume http)}

\item{regex_pattern}{(character) a uri as a regex character string,
see \link[base:regex]{base::regex}. if scheme is missing, it is added (we assume
http)}
}
\description{
UriPattern
}
\details{
\strong{Methods}
\describe{
\item{\code{add_query_params}}{
Add query parameters to the URI
- query_params
}
\item{\code{matches(uri)}}{
Match a uri against that given in \code{pattern}
- uri (character) a uri, including scheme (i.e., http or https)
}
}
}
\examples{
# trailing slash
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://foobar.com")
z$matches("http://foobar.com/")

# default ports
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://foobar.com:80")
z$matches("http://foobar.com:80/")
z$matches("http://foobar.com:443")
z$matches("http://foobar.com:443/")

# user info
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://user:pass@foobar.com")

# regex
(z <- UriPattern$new(regex_pattern = ".+ample\\\\.."))
z$matches("http://sample.org")
z$matches("http://example.com")
z$matches("http://tramples.net")

# add query parameters
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$add_query_params(list(pizza = "cheese", cheese = "cheddar"))
z$pattern

(z <- UriPattern$new(pattern = "http://foobar.com"))
z$add_query_params(list(pizza = "deep dish", cheese = "cheddar"))
z$pattern
}
\keyword{internal}
