% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemspider.R
\name{cs_prop}
\alias{cs_prop}
\title{Get predicted chemical properties from ChemSpider}
\usage{
cs_prop(csid, verbose = TRUE, ...)
}
\arguments{
\item{csid}{character,  ChemSpider ID.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
A list of lists with of three: acd (data.frame), epi (data.frame) and source_url.
}
\description{
Get predicted (ACD/Labs and EPISuite) chemical properties from ChemSpider,
see \url{https://www.chemspider.com/}
}
\note{
Please respect the Terms & conditions \url{https://www.rsc.org/help-legal/legal/terms-conditions/}.
}
\examples{
\dontrun{
out <- cs_prop(5363)
out[[1]]$epi

out2 <- cs_prop(c(5363, 2157))
# extract Log Octanol-Water Partition Coef from EPI
sapply(out2, function(y){
  y$epi$value_pred[y$epi$prop == 'Log Octanol-Water Partition Coef']
})
}
}
\seealso{
\code{\link{get_csid}} to retrieve ChemSpider IDs,
\code{\link{cs_compinfo}} for extended compound information.
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
