% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeVariableImportance.R
\name{computeVariableImportance}
\alias{computeVariableImportance}
\title{Computes variable importance of (groups of) variables of fitted a trophicSDM model.}
\usage{
computeVariableImportance(tSDM, groups = NULL)
}
\arguments{
\item{tSDM}{A trophicSDMfit object obtained with trophicSDM()}

\item{groups}{A list where each element is group. Each group is specified as a vector containing species or environmental covariates names of a given group. Each element of the list (i.e. each group) has to be named.}
}
\value{
A groups x species matrix containing variable importance for each groups of variables and each species.
}
\description{
Computes variable importance of (groups of) variables of fitted a trophicSDM model, for each species. Variable importance are computed as the standardised regression coefficients (summed across species of the same group). Standardisation is done using latent variable standardisation described in Grace et al. 2018.
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 100,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
#Compute the importance of each variable
computeVariableImportance(m)
#Compute the importance of three different set of variables
computeVariableImportance(m, groups =list("X" = c("X_1","X_2"), 
                                             "Ybasal" = c("Y1","Y2","Y3"),
                                             "Ypredator"= c("Y4", "Y5", "Y6")))
}
\references{
Grace, J. B., Johnson, D. J., Lefcheck, J. S., and Byrnes, J. E. K.. 2018. Quantifying relative importance: computing standardized effects in models with binary outcomes. Ecosphere 9(6):e02283.
}
\author{
Giovanni Poggiato
}
