% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDMfit.R
\name{SDMfit}
\alias{SDMfit}
\title{Fitting a single-species SDM}
\usage{
SDMfit(
  focal,
  Y,
  X,
  G,
  formula.foc,
  sp.formula = NULL,
  sp.partition = NULL,
  mode = "prey",
  method = "stan_glm",
  family,
  penal = NULL,
  iter = 1000,
  chains = 2,
  verbose = TRUE
)
}
\arguments{
\item{focal}{the name of the species to be modeled}

\item{Y}{The sites x species matrix containing observed species distribution (e.g. presence-absence).}

\item{X}{The design matrix, i.e. sites x predictor matrix containing the value of each explanatory variable (e.g. the environmental conditions) at each site.}

\item{G}{The species interaction network (aka metaweb). Needs to be an igraph object. Links must go from predator to preys. It needs to be a directed acyclic graph.}

\item{formula.foc}{The formula for the abiotic part of the species distribution model.}

\item{sp.formula}{(optional) It allows to specify a particular definition of the biotic part of the model, e.g., using composite variables (e.g., richness), or an interaction of the biotic and abiotic component. More details in 'Details'.}

\item{sp.partition}{(optional) a list to specify groups of species that are used to compute composite variables, e.g., a species can be modeled as a function of the richness of each group of preys. It has to be a list, each element is a vector containing the names of species in the group.}

\item{mode}{"prey" if bottom-up control (default), "predators" otherwise. Notice that G needs to be such that links point from predators to prey.}

\item{method}{which SDM method to use. For now the available choices are: "glm" (frequentist) or "stan_glm" (full Bayesian MCMC, default). Notice that using "glm" does not allow error propagation when predicting.}

\item{family}{the family parameter of the glm function (see glm). family=gaussian(link ="identity") for gaussian data or family=binomial(link = "logit") or binomial(link = "probit") for presence-absence data.}

\item{penal}{(optional, default to NULL) Penalisation method to shrink regression coefficients.If NULL (default), the model does not penalise the regression coefficient. For now, available penalisation method are "horshoe" for stan_glm, "elasticnet" for glm and  "coeff.signs" (prey coefficients are set to positive and predator coefficients to negative) for glm and stan_glm.}

\item{iter}{(for method="stan_glm" only) Number of iterations for each MCMC chain if stan_glm is used}

\item{chains}{(for method="stan_glm" only) Number of MCMC chains (default to 2)}

\item{verbose}{Whether to print algorithm progresses}
}
\value{
A list containing 'm', a "SDMfit" object and 'form.all', a string describing the formula of the SDMfit object. The "SDM" fit object contains:
\item{model}{The output of the function used to fit the SDM. E.g., an object of class "glm" is method = "glm", an object of class "stanreg" if method = "stan_glm".}
\item{Y}{A numeric vector of standard errors on parameters}

\item{form.all}{The formula used to fit the SDM (both abiotic and biotic terms)}

\item{method, family, penal, iter, chains}{The input parameters used to fit the SDM.}

\item{sp.name}{The name of the species modeled}

\item{data}{The model.frame data.frame used to fit the model}

\item{coef}{The inferred coefficients (with credible intervals or p-values when available)}

\item{AIC}{The AIC of the local model}

\item{log.lik}{The log.likelihood of the local model}
}
\description{
SDMfit is used to fit a single species SDM, what we call a 'local model' of trophicSDM. It returns an object of class 'SDMfit'. Requires basically the same inputs of trophicSDM, with the requirement to specify with the parameter 'focal' the species that is modeled by the SDMfit.
}
\details{
"sp.formula" and "sp.partition" can be combined to define any kind of composite variables for the biotic part of the formula. "sp.formula" can be :
\itemize{
\item A string defining a formula as function of "richness". E.g., sp.formula="richness+I(richness)^2" (species are modeled as a function of a quadratic polynomial of their prey richness), "I(richness>0)" (species are modeled as a function of a dummy variable that is equal to 1 when at least one species is present). Importantly, when group of preys (or predators) are specified by "sp.partition", species are modeled as a function of the composite variable specified by "sp.formula" for each of their prey groups.\cr
\item A more flexible option is to specify sp.formula as a list (whose names are species' names) that contains for each species the definition biotic part of the model. Notice that, in this case, the function does not check that the model is a DAG. This allow to define any kind of composite variable, or to model interactions between environmental covariates and preys (or predators).
}
}
\examples{
data(Y,X,G)
# Run a local model (i.e. a SDM) for species Y6
mySDM = SDMfit("Y6", Y, X, G, "~X_1 + X_2", mode = "prey",
       method = "stan_glm", family = binomial(link = "logit"))
mySDM$m
}
\author{
Giovanni Poggiato and Jérémy Andréoletti
}
