% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Omega.R
\name{omega}
\alias{omega}
\title{Computation of Fisher information  matrice}
\usage{
omega(ar = NULL, ma = NULL, y)
}
\arguments{
\item{ar}{Vector of AR coefficients. If \code{NULL},  the simulation is a MA process.}

\item{ma}{Vector of MA coefficients. If \code{NULL},  the simulation is a AR process.}

\item{y}{Univariate time series.}
}
\value{
A list of matrix containing:
\describe{
   \item{\code{I}}{Matrix \code{I} computed in function \code{\link{matXi}}.}
   \item{\code{J}}{Matrix \code{J} computed as \eqn{\frac{2}{n} H(e) H(e)^t } where \eqn{e} is the residuals vector.}
   \item{\code{J.inv}}{Inverse of the matrix \code{J}.}
   \item{\code{matOmega}}{Matrix variance-covariance in the weak case computed as \eqn{J^{-1}IJ^{-1}}.}
   \item{\code{matvar.strong}}{Matrix variance-covariance in the strong case computed as 
         \eqn{2\sigma^2J^{-1}}.}
   \item{\code{standard.dev.Omega}}{Standard deviation of the matrix \code{matOmega}.}
   \item{\code{standard.dev.strong}}{Standard deviation of the matrix \code{matvar.strong}.}
   \item{\code{sig2}}{Innovation variance estimate.}
}
}
\description{
Computes matrices of Fisher information like \eqn{I}, \eqn{J}.
}
\examples{
y <- sim.ARMA(n = 1000, ar = c(0.95,-0.8), ma = -0.6)
\donttest{est<-estimation(p = 2, q = 1, y = y)}
\donttest{omega(ar = est$ar, ma = est$ma, y = y)}

estCAC<-estimation(p = 1, q = 1, y = CAC40return.sq, meanparam = TRUE)
\donttest{omega(ar = estCAC$ar, ma = estCAC$ma, y = CAC40return.sq)}
}
