% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa_control.R
\name{rpa_control_newedge}
\alias{rpa_control_newedge}
\title{Control new edges in each step. Defined for \code{rpanet}.}
\usage{
rpa_control_newedge(
  sampler = NULL,
  snode.replace = TRUE,
  tnode.replace = TRUE,
  node.replace = TRUE
)
}
\arguments{
\item{sampler}{A function used for sampling the number of new edges to be
added at each step. If \code{NULL}, one new edge will be added at each
step. If a function is provided, it must accept a single argument,
\code{n}, and return a vector of length \code{n} that represents the
sampled number of new edges.}

\item{snode.replace}{Logical. Determines whether the source nodes in the same
step should be sampled with replacement. Defined for directed networks.}

\item{tnode.replace}{Logical. Determines whether the target nodes in the same
step should be sampled with replacement. Defined for directed networks.}

\item{node.replace}{Logical. Determines whether the nodes in the same step
should be sampled with replacement. Defined for undirected networks. If
FALSE, self-loops will not be allowed under beta scenario.}
}
\value{
A list of class \code{rpacontrol} with components \code{sampler},
  \code{snode.replace}, \code{tnode.replace} and \code{node.replace} with
  meanings as explained under 'Arguments'.
}
\description{
Control new edges in each step. Defined for \code{rpanet}.
}
\examples{
my_rpois <- function(n) rpois(n, lambda = 2) + 1
control <- rpa_control_newedge(
  sampler = my_rpois,
  node.replace = FALSE
)
}
