% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dprewire_undirected_cpp}
\alias{dprewire_undirected_cpp}
\title{Degree preserving rewiring process for undirected networks.}
\usage{
dprewire_undirected_cpp(
  iteration,
  nattempts,
  node1,
  node2,
  degree1,
  degree2,
  index1,
  index2,
  e,
  rewire_history
)
}
\arguments{
\item{iteration}{Integer, number of iterations of nattempts rewiring attempts.}

\item{nattempts}{Integer, number of rewiring attempts per iteration.}

\item{node1}{Vector, first column of edgelist.}

\item{node2}{Vector, second column of edgelist.}

\item{degree1}{Vector, degree of node1 and node2.}

\item{degree2}{Vector, degree of node2 and node1. degree1 
and degree2 are used to calculate assortativity coefficient,
i.e., degree correlation.}

\item{index1}{Index of the first column of edgelist. 
index1 and index2 bridge the nodes' degree and the 
structure e.}

\item{index2}{Index of the second column of edgelist..}

\item{e}{Matrix, target structure e (eta) generated by
\code{wdnet::get_eta_undirected()}.}

\item{rewire_history}{Logical, whether the rewiring history should be returned.}
}
\value{
Node sequences, assortativity coefficient after each iteration
  and rewiring history.
}
\description{
Degree preserving rewiring process for undirected networks.
}
\keyword{internal}
