% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assortativity.R
\name{assortcoef}
\alias{assortcoef}
\title{Assortativity coefficient}
\usage{
assortcoef(
  edgelist = NULL,
  edgeweight = NULL,
  adj = NULL,
  directed = TRUE,
  f1 = NULL,
  f2 = NULL
)
}
\arguments{
\item{edgelist}{A two column matrix represents edges. If \code{NULL},
\code{edgelist} and \code{edgeweight} will be extracted from the adjacency
matrix \code{adj}.}

\item{edgeweight}{A vector represents the weight of edges. If \code{edgelist}
is provided and \code{edgeweight} is \code{NULL}, all the edges will be
considered have weight 1.}

\item{adj}{An adjacency matrix.}

\item{directed}{Logical. Whether the edges will be considered as directed.}

\item{f1}{A vector, represents the first feature of existing nodes. Number of
nodes \code{= length(f1) = length(f2)}. Defined for directed networks. If
\code{NULL}, out-strength will be used.}

\item{f2}{A vector, represents the second feature of existing nodes. Defined
for directed networks. If \code{NULL}, in-strength will be used.}
}
\value{
Assortativity coefficient for undirected networks, or four
  assortativity coefficients for directed networks.
}
\description{
Compute the assortativity coefficient of a network.
}
\note{
When the adjacency matrix is binary (i.e., directed but unweighted
  networks), \code{assortcoef} returns the assortativity coefficient proposed 
  in Foster et al. (2010).
}
\examples{
set.seed(123)
control <- rpa_control_edgeweight(distribution = rgamma,
    dparams = list(shape = 5, scale = 0.2), shift = 0)
netwk <- rpanet(nstep = 10^4, control = control)
result <- assortcoef(netwk$edgelist, edgeweight = netwk$edgeweight, directed = TRUE)

}
\references{
\itemize{ \item Foster, J.G., Foster, D.V., Grassberger, P. and
  Paczuski, M. (2010). Edge direction and the structure of networks.
  \emph{Proceedings of the National Academy of Sciences of the United
  States}, 107(24), 10815--10820. \item Yuan, Y. Zhang, P. and Yan, J.
  (2021). Assortativity coefficients for weighted and directed networks.
  \emph{Journal of Complex Networks}, 9(2), cnab017.}
}
