% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selenium.R
\name{selenium}
\alias{selenium}
\title{Start Selenium Server}
\usage{
selenium(port = 4567L, version = "latest", chromever = "latest",
  geckover = "latest", iedrver = NULL, phantomver = "2.1.1",
  check = TRUE, verbose = TRUE, retcommand = FALSE, ...)
}
\arguments{
\item{port}{Port to run on}

\item{version}{what version of Selenium Server to run. Default = "latest"
which runs the most recent version. To see other version currently
sourced run binman::list_versions("seleniumserver")}

\item{chromever}{what version of Chrome driver to run. Default = "latest"
which runs the most recent version. To see other version currently
sourced run binman::list_versions("chromedriver"), A value of NULL
excludes adding the chrome browser to Selenium Server.}

\item{geckover}{what version of Gecko driver to run. Default = "latest"
which runs the most recent version. To see other version currently
sourced run binman::list_versions("geckodriver"), A value of NULL
excludes adding the firefox browser to Selenium Server.}

\item{iedrver}{what version of IEDriverServer to run. Default = "latest"
which runs the most recent version. To see other version currently
sourced run binman::list_versions("iedriverserver"), A value of NULL
excludes adding the internet explorer browser to Selenium Server.
NOTE this functionality is Windows OS only.}

\item{phantomver}{what version of PhantomJS to run. Default = "2.2.1"
which runs the most recent stable version. To see other version
currently
sourced run binman::list_versions("phantomjs"), A value of NULL
excludes adding the PhantomJS headless browser to Selenium Server.}

\item{check}{If TRUE check the versions of selenium available and the
versions of associated drivers (chromever, geckover, phantomver,
iedrver). If new versions are available they will be downloaded.}

\item{verbose}{If TRUE, include status messages (if any)}

\item{retcommand}{If TRUE return only the command that would be passed
to \code{\link{spawn_process}}}

\item{...}{pass additional options to the driver}
}
\value{
Returns a list with named elements process, output, error
    and stop. process is the output from calling \code{\link{spawn_process}}
    output, error and stop are functions calling
    \code{\link{process_read}}, \code{\link{process_read}} with "stderr"
    pipe and \code{\link{process_kill}}  respectively  on process.
}
\description{
Start Selenium Server
}
\examples{
\dontrun{
selServ <- selenium()
selServ$output()
selServ$stop()
}
}
