% Generated by roxygen2 (4.0.2): do not edit by hand
\name{changepoints}
\alias{changepoints}
\alias{changepoints.sbs}
\alias{changepoints.wbs}
\title{Change-points detected by WBS or BS}
\usage{
changepoints(object, ...)

\method{changepoints}{sbs}(object, th = NULL, th.const = 1.3, Kmax = NULL,
  ...)

\method{changepoints}{wbs}(object, th = NULL, th.const = 1.3, Kmax = 50,
  penalty = c("ssic.penalty", "bic.penalty", "mbic.penalty"), ...)
}
\arguments{
\item{object}{an object of 'wbs' or 'sbs' class returned by, respectively, \code{\link{wbs}} and \code{\link{sbs}} functions}

\item{...}{further arguments that may be passed to the penalty functions}

\item{th}{a vector of positive scalars}

\item{th.const}{a vector of positive scalars}

\item{Kmax}{a maximum number of change-points to be detected}

\item{penalty}{a character vector with names of penalty functions used}
}
\value{
\item{sigma}{Median Absolute Deviation estimate of the noise level}
\item{th}{a vector of thresholds}
\item{no.cpt.th}{the number of change-points detected for each value of \code{th}}
\item{cpt.th}{a list with the change-points detected for each value of \code{th}}
\item{Kmax}{a maximum number of change-points detected}
\item{ic.curve}{a list with values of the chosen information criteria}
\item{no.cpt.ic}{the number of change-points detected for each information criterion considered}
\item{cpt.ic}{a list with the change-points detected for each information criterion considered}
}
\description{
The function applies user-specified stopping criteria to extract change-points from \code{object}
generated by \code{\link{wbs}} or \code{\link{sbs}}. For \code{object} of class 'sbs', the function returns
change-points whose corresponding test statistic exceeds threshold given in \code{th}. For \code{object} of class 'wbs',
the change-points can be also detected using information criteria with penalties specified in \code{penalty}.
}
\details{
For the change-point detection based on thresholding (\code{object} of class 'sbs' or 'wbs'), the user can either specify the thresholds in \code{th} directly,
determine the maximum number \code{Kmax} of change-points to be detected, or let \code{th} depend on \code{th.const}.

When \code{Kmax} is given, the function automatically sets \code{th} to the lowest threshold such that the number of detected change-points is lower or equal than \code{Kmax}.
Note that for the BS algorithm it might be not possible to find the threshold such that exactly \code{Kmax} change-points are found.

When  \code{th} and \code{Kmax} are omitted, the threshold value is set to
\deqn{th = sigma \times th.const \sqrt{2\log(n)},}{th=sigma * th.const* sqrt(2 log(n)),}
where sigma is the Median Absolute Deviation estimate of the noise level and \eqn{n}{n} is the number of elements in \code{x}.

For the change-point detection based on information criteria (\code{object} of class 'wbs' only),
the user can specify both the maximum number of change-points (\code{Kmax}) and a type of the penalty used.
Parameter \code{penalty} should contain a list of characters with names of the functions of at least two arguments (\code{n} and \code{cpt}).
For each penalty given, the following information criterion is minimized over candidate sets of change-points \code{cpt}:
\deqn{\frac{n}{2}\log\hat{\sigma}_{k}^{2}+penalty(n,cpt),}{n/2 log(sigma_k)+ penalty(n,cpt),}
where \eqn{k}{k} denotes the number of elements in \eqn{cpt}{cpt}, \eqn{\hat{\sigma}_{k}}{sigma_k} is the corresponding maximum
likelihood estimator of the residual variance.
}
\examples{
#we generates  gaussian noise + Poisson process signal with 10 jumps on average
set.seed(10)
N <- rpois(1,10)
true.cpt <- sample(1000,N)
m1 <- matrix(rep(1:1000,N),1000,N,byrow=FALSE)
m2 <- matrix(rep(true.cpt,1000),1000,N,byrow=TRUE)
x <- rnorm(1000) + apply(m1>=m2,1,sum)

# we apply  the BS and WBS algorithms with default values for their parameters

s <- sbs(x)
w <- wbs(x)

s.cpt <- changepoints(s)
s.cpt

w.cpt <- changepoints(w)
w.cpt

#we can use different stopping criteria, invoking sbs/wbs functions is not necessary

s.cpt <- changepoints(s,th.const=c(1,1.3))
s.cpt
w.cpt <- changepoints(w,th.const=c(1,1.3))
w.cpt
}

