\name{spp.mle}
\alias{spp.mle}
\alias{spp2.mle}
\title{Wavelet-based Maximum Likelihood Estimation for Seasonal
  Persistent Processes}
\description{
  Parameter estimation for a seasonal persistent (seasonal long-memory)
  process is performed via maximum likelihood on the wavelet
  coefficients.
}
\usage{spp.mle(y, wf, J=log(length(y),2)-1, p=0.01, frac=1)
spp2.mle(y, wf, J=log(length(y),2)-1, p=0.01, dyadic=TRUE, frac=1)
}
\arguments{
  \item{y}{Not necessarily dyadic length time series.}
  \item{wf}{Name of the wavelet filter to use in the decomposition.  See
    \code{\link{wave.filter}} for those wavelet filters available.}
  \item{J}{Depth of the discrete wavelet packet transform.}
  \item{p}{Level of significance for the white noise testing procedure.}
  \item{dyadic}{Logical parameter indicating whether or not the original
    time series is dyadic in length.}
  \item{frac}{Fraction of the time series that should be used in
    constructing the likelihood function.}
}
\value{
  List containing the maximum likelihood estimates (MLEs) of
  \eqn{\delta}, \eqn{f_G} and \eqn{\sigma^2}, along with the value of
  the likelihood for those estimates.
}
\details{
  The variance-covariance matrix of the original time series is
  approximated by its wavelet-based equivalent.  A Whittle-type
  likelihood is then constructed where the sums of squared wavelet
  coefficients are compared to bandpass filtered version of the true
  spectral density function.  Minimization occurs for the fractional
  difference parameter \eqn{d} and the Gegenbauer frequency \eqn{f_G},
  while the innovations variance is subsequently estimated.
}
\references{
  Whitcher, B. (2003)
  Wavelet-based estimation for seasonal long-memory processes.
  Technical Report.
}
\seealso{
  \code{\link{fdp.mle}}
}
%\examples{}
\author{B. Whitcher}
\keyword{ts}
