% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_len.R
\name{fetch_len}
\alias{fetch_len}
\title{Calculate the fetch length around a point}
\usage{
fetch_len(p, bearings, shoreline, dmax, spread = 0, projected = FALSE,
  check_inputs = TRUE)
}
\arguments{
\item{p}{SpatialPoints* object of length 1 (single point).}

\item{bearings}{Vector of bearings, in degrees.}

\item{shoreline}{SpatialLines* or SpatialPolygons* object representing the
shoreline.}

\item{dmax}{Maximum value of fetch length, returned if there is no land
within a distance of \code{dmax} from a given bearing.}

\item{spread}{Vector of relative bearings (in degrees) for which
to calculate fetch around each main bearing (see details).}

\item{projected}{Should projected coordinates be used to calculate fetch?}

\item{check_inputs}{Should the validity of inputs be checked? It is
recommended to keep this TRUE, unless this function is called repeatedly from
another function that already checks inputs.}
}
\value{
A named vector representing the fetch length for each direction
 given in \code{bearings}.
}
\description{
Given a point, a shoreline layer and a vector of wind directions (bearings),
\code{fetch_len} calculates the distance from point to shore for each bearing.
}
\details{
The fetch length (or fetch) is the distance of open water over which the wind
can blow in a specific direction. Note that bearings represent the direction
from where the wind originates.

The optional \code{spread} argument defines relative directions that are
added to each main bearing to produce a set of sub-bearings. The fetch lengths
calculated for each sub-bearing are averaged with weights proportional to
\code{cos(spread)}. By default, \code{spread = 0} and fetch length is
calculated for the main bearings only.

If \code{projected} is FALSE (the default), the input data must be in WGS84
geographic (longitude, latitude) coordinates. Geodesic distances are calculated
using the \code{\link[geosphere]{distGeo}} function from the geosphere R
package. All distance are expressed in meters.

If \code{projected} is TRUE, the input data (\code{p} and \code{shoreline})
must share the same projection. Projected distances are calculated with the
rgeos R package. All distances are expressed in the projection's coordinates.

If the shoreline layer is given as SpatialPolygons*, the function verifies
that the input point is outside all polygons (i.e. in water). If this is
not the case, it issues a warning and returns a vector of \code{NA}.
}
\examples{
 pt <- SpatialPoints(matrix(c(0, 0), ncol = 2),
                     proj4string = CRS("+proj=longlat"))
 # Shoreline is a rectangle from (-0.2, 0.25) to (0.3, 0.5)
 rect <- Polygon(cbind(c(rep(-0.2, 2), rep(0.3, 2), -0.2),
                       c(0.25, rep(0.3, 2), rep(0.25, 2))))
 land <- SpatialPolygons(list(Polygons(list(rect), ID = 1)),
                         proj4string = CRS("+proj=longlat"))
 fetch_len(pt, bearings = c(0, 45, 225, 315), land,
           dmax = 50000, spread = c(-10, 0, 10))
}
\seealso{
\code{\link{fetch_len_multi}} for an efficient alternative when
 computing fetch length for multiple points.
}
