% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLegislation.R
\name{getLegislation}
\alias{getLegislation}
\title{Get summary information on a particular bill}
\usage{
getLegislation(
  biennium,
  billNumber,
  paired = TRUE,
  type = c("df", "list", "xml")
)
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{billNumber}{Character or numeric vector containing the bill number(s)
to be retrieved.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getLegislation} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get legislative summary information for a particular bill,
including bill ID, introduction date, bill title(s), and
description
}
\examples{
getLegislation("2007-08", "1001")

## get XML data for the first 100 hundred bills of the 2007-08 session
\dontrun{getLegislation("2007-08", 1001:1100, type = "xml")}
}
