% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixwavs.R
\name{fixwavs}
\alias{fixwavs}
\title{Fix .wav files to allow importing them into R}
\usage{
fixwavs(checksels = NULL, files = NULL, samp.rate = NULL, bit.rate = NULL,
 path = NULL, ...)
}
\arguments{
\item{checksels}{Data frame with results from \code{\link{checksels}}.}

\item{files}{Character vector with the names of the wav files to fix. Default is \code{NULL}.}

\item{samp.rate}{Numeric vector of length 1 with the sampling rate (in kHz) for output files. Default is \code{NULL}.}

\item{bit.rate}{Numeric vector of length 1 with the dynamic interval (i.e. bit rate) for output files.
Default is \code{NULL}. Currently not available.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{...}{Additional arguments to be passed to \code{\link[seewave]{sox}}.}
}
\value{
A folder inside the working directory (or path provided) all 'converted_sound_files', containing 
sound files in a format that can be imported in R.
}
\description{
\code{fixwavs} fixes sound files in .wav format so they can be imported into R.
}
\details{
This function aims to simplify the process of converting sound files that cannot be imported into R to 
a format that can actually be imported. Problematic files can be determined using \code{\link{checksels}}. The  
\code{\link{checksels}} output can be directly input using the argument 'checksels'. Alternatively a vector of file 
names to be "fixed" can be provided (argument 'files'). Internally the function calls 'sox' through the 
\code{\link[seewave]{sox}} function. 'sox' must be installed to be able to run this function.
}
\examples{
\dontrun{
# Set temporary working directory
setwd(tempdir())

data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav") 

fixwavs(files = selec.table$sound.files)

#check this folder
getwd()
}

}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
#last modification on march-15-2017 (MAS)
}

