% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catalog2pdf.R
\name{catalog2pdf}
\alias{catalog2pdf}
\title{\code{catalog2pdf} combines \code{\link{catalog}} images into pdfs}
\usage{
catalog2pdf(keep.img = TRUE, overwrite = FALSE, parallel = 1, path = NULL, 
pb = TRUE, by.img.suffix = FALSE, ...)
}
\arguments{
\item{keep.img}{Logical argument. Indicates whether jpeg files should be kept (default) or remove.
(including sound file and page number) should be magnified. Default is 1.}

\item{overwrite}{Logical argument. If \code{TRUE} all jpeg pdf will be produced again 
when code is rerun. If \code{FALSE} only the ones missing will be produced. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}

\item{by.img.suffix}{Logical. If \code{TRUE} catalogs with the same image suffix will be 
put together in a single pdf (so one pdf per image suffix in the catalog 
images). Default is \code{FALSE} (i.e. no suffix).}

\item{...}{Additional arguments to be passed to the internal pdf creating function \code{\link[grDevices]{pdf}} for customizing output.}
}
\description{
\code{catalog2pdf} combines \code{\link{catalog}} images into pdfs
}
\details{
The function combines catalog images in .jpeg format from the \code{\link{catalog}} function into pdfs. Note that using lower resolution and smaller dimension (width and height) when creating catalogs will substantially decrease the size of pdf files (which could be pretty big).
}
\examples{
\dontrun{
# Set temporary working directory
setwd(tempdir())

# save sound file examples
data(list = c("Phae.long1", "Phae.long2"))
writeWave(Phae.long1,"Phae.long1.wav") 
writeWave(Phae.long2,"Phae.long2.wav")

catalog(X = selec.table, nrow = 2, ncol = 4)

# now create single pdf removing jpeg
catalog2pdf(keep.img = FALSE)

# check this floder
getwd()
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{catalog2pdf}}, 
\url{https://marce10.github.io/2017/03/17/Creating_song_catalogs.html}
}

