% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specreator.R
\name{specreator}
\alias{specreator}
\title{Spectrograms of selected signals}
\usage{
specreator(X, wl = 512, flim = c(0, 22), wn = "hanning", pal
  = reverse.gray.colors.2, ovlp = 70, inner.mar = c(5, 4, 4, 2), outer.mar =
  c(0, 0, 0, 0), picsize = 1, res = 100, cexlab = 1, title = TRUE,
  propwidth = FALSE, xl = 1, osci = FALSE, gr = FALSE,  sc = FALSE, line = TRUE,
  mar = 0.05, it = "jpeg", parallel = 1, path = NULL, pb = TRUE, fast.spec = FALSE, ...)
}
\arguments{
\item{X}{Data frame with results containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signals (start and end).
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can be used as the input data frame.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{flim}{A numeric vector of length 2 for the frequency limit (in kHz) of 
the spectrogram, as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{pal}{A color palette function to be used to assign colors in the 
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2.}

\item{ovlp}{Numeric vector of length 1 specifying the percent overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2). 
Specifies number of lines in inner plot margins where axis labels fall, 
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0). 
Specifies number of lines in outer plot margins beyond axis labels, with 
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length 1. Controls relative size of 
spectrogram. Default is 1. Ignored when propwidth is \code{TRUE}.}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/ 
presentation quality.}

\item{cexlab}{Numeric vector of length 1 specifying the relative size of axis 
labels. See \code{\link[seewave]{spectro}}.}

\item{title}{Logical argument to add a title to individual spectrograms. 
Default is \code{TRUE}.}

\item{propwidth}{Logical argument to scale the width of spectrogram 
proportionally to duration of the selection. Default is \code{FALSE}.}

\item{xl}{Numeric vector of length 1. A constant by which to scale 
spectrogram width if propwidth = \code{TRUE}. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is \code{FALSE}.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is 
\code{FALSE}.}

\item{line}{Logical argument to add red lines at start and end times of selection 
(or box if low.f and high.f columns are provided). Default is \code{TRUE}.}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the start and end points of selections,
dealineating spectrogram limits. Default is 0.05.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially 
increases performance (much faster), although some options become unavailable, as collevels, and sc (amplitude scale).
This option is indicated for signals with high background noise levels. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}}, \code{\link[monitoR]{topo.1}} and \code{\link[monitoR]{rainbow.1}} (which should be imported from the package monitoR) seem
to work better with 'fast' spectograms. Palette colors \code{\link[monitoR]{gray.1}}, \code{\link[monitoR]{gray.2}}, 
\code{\link[monitoR]{gray.3}} offer 
decreasing darkness levels. THIS IS STILL BEING TESTED.}

\item{...}{Additional arguments to be passed to the internal spectrogram creating function for customizing graphical output. The function is a modified version of \code{\link[seewave]{spectro}}, so it takes the same arguments.}
}
\value{
Image files containing spectrograms of the signals listed in the input data frame.
}
\description{
\code{specreator} creates spectrograms of signals selected by \code{\link{manualoc}} or \code{\link{autodetec}}.
}
\details{
This function provides access to bath process of (a modified version of) the \code{\link[seewave]{spectro}} function from the 'seewave' package. The function creates spectrograms for visualization of vocalizations. 
Setting inner.mar to c(4,4.5,2,1) and outer.mar to c(4,2,2,1) works well when picsize = 2 or 3. 
Title font size, inner.mar and outer.mar (from mar and oma) don't work well when osci or sc = TRUE,
this may take some optimization by the user. Setting 'fast' argument to TRUE significantly increases speed, although 
some options become unavailable, as collevels, and sc (amplitude scale). This option is indicated for signals with 
high background noise levels.
}
\examples{
\dontrun{ 
# First set empty folder
setwd(tempdir())
data(list = c("Phae.long1", "Phae.long2","selec.table"))
writeWave(Phae.long1, "Phae.long1.wav") #save sound files 
writeWave(Phae.long2, "Phae.long2.wav")

# make spectrograms

specreator(selec.table, flim = c(0, 11), res = 300, mar = 0.05, wl = 300)
 
 #' #check this folder!!
getwd()
}

}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}) and Grace Smith Vidaurre
}
\seealso{
\code{\link{trackfreqs}} for creating spectrograms to visualize 
  frequency measurements by \code{\link{specan}}, \code{\link{snrspecs}} for 
  creating spectrograms to optimize noise margins used in \code{\link{sig2noise}}

Other spectrogram.creators: \code{\link{dfDTW}},
  \code{\link{dfts}}, \code{\link{ffDTW}},
  \code{\link{ffts}}, \code{\link{snrspecs}},
  \code{\link{sp.en.ts}}, \code{\link{trackfreqs}}
}

