% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{envelope}
\alias{envelope}
\title{Calculates the absolute amplitude envelope}
\arguments{
\item{x}{Numeric vector with amplitude values. Required.}

\item{ssmooth}{Numeric vector of length 1 indicating the size of the sliding window use to smooth envelopes. Default is 0 (no smoothing).}
}
\value{
An amplitude envelope.
}
\description{
Calculates the absolute amplitude envelope
}
\details{
The function calculates the absolute amplitude envelope of an amplitude vector using compiled C code which is usually several times faster.
}
\examples{
{
data(tico)

amp_env <- envelope(tico@left, ssmooth = 100)
}
}
\references{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
\seealso{
\code{\link[seewave]{env}}.
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr}) & Paula Monge
}
