% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailor_sels.R
\name{tailor_sels}
\alias{tailor_sels}
\title{Interactive view of spectrograms to tailor selections}
\usage{
tailor_sels(
  X = NULL,
  wl = 512,
  flim = c(0, 22),
  wn = "hanning",
  mar = 0.5,
  osci = TRUE,
  pal = reverse.gray.colors.2,
  ovlp = 70,
  auto.next = FALSE,
  pause = 1,
  comments = TRUE,
  path = NULL,
  frange = TRUE,
  fast.spec = FALSE,
  ext.window = TRUE,
  width = 15,
  height = 5,
  index = NULL,
  collevels = NULL,
  title = c("sound.files", "selec"),
  ts.df = NULL,
  col = "#E37222",
  alpha = 0.7,
  auto.contour = FALSE,
  ...
)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' object or data frame with the following columns: 1) "sound.files": name of the .wav
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end":
end time of selections. Notice that, if an output file ("seltailor_output.csv") is found in the working directory it will be given priority over an input data frame.}

\item{wl}{A numeric vector of length 1 specifying the spectrogram window length. Default is 512.}

\item{flim}{A numeric vector of length 2 specifying the frequency limit (in kHz) of
the spectrogram, as in the function \code{\link[seewave]{spectro}}.
Default is c(0,22).}

\item{wn}{A character vector of length 1 specifying the window function (by default "hanning").
See function \code{\link[seewave]{ftwindow}} for more options.}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the
start and end points of the selections to define spectrogram limits. Default is 0.5.}

\item{osci}{Logical argument. If \code{TRUE} adds a oscillogram whenever the spectrograms are produced
with higher resolution (see seltime). Default is \code{TRUE}.
The external program must be closed before resuming analysis. Default is \code{NULL}.}

\item{pal}{A color palette function to be used to assign colors in the
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2. See Details.}

\item{ovlp}{Numeric vector of length 1 specifying the percent overlap between two
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{auto.next}{Logical argument to control whether the functions moves automatically to the
next selection. The time interval before moving to the next selection is controlled by the 'pause' argument. Ignored if \code{ts.df = TRUE}.}

\item{pause}{Numeric vector of length 1. Controls the duration of the waiting period before
moving to the next selection (in seconds). Default is 1.}

\item{comments}{Logical argument specifying if 'sel.comment' (when in data frame) should be included
in the title of the spectrograms. Default is \code{TRUE}.}

\item{path}{Character string containing the directory path where the sound files are located.}

\item{frange}{Logical argument specifying whether limits on frequency range should be
 recorded.
If \code{TRUE} (default) time and frequency limits are recorded.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially
increases performance (much faster), although some options become unavailable, as sc (amplitude scale).
This option is indicated for signals with high background noise levels. Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}},
\code{\link[monitoR:specCols]{gray.3}}, \code{\link[monitoR:specCols]{topo.1}} and \code{\link[monitoR:specCols]{rainbow.1}} (which should be imported from the package monitoR) seem
to work better with 'fast' spectrograms. Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}},
\code{\link[monitoR:specCols]{gray.3}} offer
decreasing darkness levels.}

\item{ext.window}{Logical. If \code{TRUE} then and external graphic window is used. Default
dimensions can be set using the 'width' and 'height' arguments. Default is \code{TRUE}.}

\item{width}{Numeric of length 1 controlling the width of the external graphic window. Ignored
if \code{ext.window = FALSE}. Default is 15.}

\item{height}{Numeric of length 1 controlling the height of the external graphic window.
Ignored if \code{ext.window = FALSE}. Default is 5.}

\item{index}{Numeric vector indicating which selections (rows) of 'X' should be tailored.
Default is \code{NULL}. Ignored when the process is resumed. This can be useful when combined
with \code{\link{filter_sels}}) output (see 'index' argument in \code{\link{filter_sels}}).}

\item{collevels}{Numeric. Set of levels used to partition the amplitude range (see
\code{\link[seewave]{spectro}}).}

\item{title}{Character vector with the names of the columns to be included in the title for each
selection.}

\item{ts.df}{Optional. Data frame with frequency contour time series of signals to be tailored. If provided then
'autonext' is set to \code{FALSE}. Default is \code{NULL}. The data frame must include the 'sound.files' and 'selec'
columns for the same selections included in 'X'.}

\item{col}{Character vector defining the color of the points when 'ts.df' is provided. Default is "#E37222" (orange).}

\item{alpha}{Numeric of length one to adjust transparency of points when adjusting frequency contours.}

\item{auto.contour}{Logical. If \code{TRUE} contours are displayed automatically
(without having to click on 'contour'). Note that adjusting the selection box
(frequency/time limits) won't be available. Default is \code{FALSE}. Ignored if
'ts.df' is not provided.}

\item{...}{Additional arguments to be passed to the internal spectrogram creating function for customizing graphical output. The function is a modified version of \code{\link[seewave]{spectro}}, so it takes the same arguments.}
}
\value{
data frame similar to X with the and a .csv file saved in the working directory with start and end time of
  selections.
}
\description{
\code{tailor_sels} produces an interactive spectrographic view in
which the start/end times and frequency range of acoustic signals listed in a data frame can be adjusted.
}
\details{
This function produces an interactive spectrographic
 view in which users can select new time/frequency
 coordinates the selections. 4 "buttons" are provided at the upper right side of the spectrogram that
  allow to stop the analysis (stop symbol, a solid rectangle), go to the next sound file (">>"), return to the
  previous selection ("<<") or delete
  the current selection ("X"). An additional "button" to tailored frequency contour is shown
  when 'ts.df' is provided. The button contains a symbol with a 4 point contour. When a unit has been selected, the function plots
  dotted lines in the start and end of the selection in the spectrogram (or a box if
  \code{frange = TRUE}). Only the last selection is kept for each
   selection that is adjusted. The function produces a .csv file (seltailor_output.csv)
   with the same information than the input data frame, except for the new time
   coordinates, plus a new column (X$tailored) indicating if the selection
  has been tailored. The file is saved in the working directory  and is updated every time the user
   moves into the next sound file (">>") or stop the process
 (stop "button"). It also return the same data frame as and object in the R environment.
   If no selection is made (by clicking on ">>") the
 original time/frequency coordinates are kept. When resuming the process (after "stop" and re-running
 the function in the same working directory), the function will continue working on the
 selections that have not been analyzed. When deleting a file (X button) an orange "X" when returning to that selection. If X is used again the selection is recovered.
 The function also displays a progress bar right on
 top of the spectrogram. The zoom can be adjusted by setting the \code{mar} argument.
 To fix contours a data.frame containing the 'sound.files' and 'selec' columns as in 'X' as well
 as the frequency values at each contour step must be provided. The function plots points corresponding to the
 time/frequency coordinates of each element of the contour. Clicking on the spectrogram will substitute the
 frequency value of the points. The contour point closest in time to the "click" will be replaced by the
 frequency value of the "click".
}
\examples{
\dontrun{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

tailor_sels(X = lbh_selec_table, flim = c(1, 12), wl = 300, auto.next = TRUE, path = tempdir())

# Read output .csv file
seltailor.df <- read.csv(file.path(tempdir(), "seltailor_output.csv"))
seltailor.df

# check this directory for .csv file after stopping function
tempdir()
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
