% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{gaps}
\alias{gaps}
\title{Gap duration}
\usage{
gaps(X = NULL, by = "sound.files", parallel = 1, pb = TRUE)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' (created 'by.song') or data frame with the following columns: 1) "sound.files": name of the sound
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end":
end time of selections.}

\item{by}{Character vector with column names. Controls the levels at which gaps will be measured. "sound.files" must always be included.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}
}
\value{
A data frame identical to that supplied in 'X', with and additional column ('gaps') with the duration of the time interval between selections.
}
\description{
\code{gaps} measures gap duration
}
\details{
The function measures the time intervals (i.e. gaps) between selections.  The gap for a given selection is calculated as the time interval to the selection immediately after. Hence, there is no gap for the last selection in a sound file (or level determined by the 'by' argument). Note that sound files are not required.
}
\examples{
{
# get warbleR sound file examples
data(list = "lbh_selec_table")

# get gaps
gaps(X = lbh_selec_table)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{inflections}}, \code{\link{song_analysis}},
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
