% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_sels.R
\name{filter_sels}
\alias{filter_sels}
\title{Subset selection data frames based on manually filtered image files}
\usage{
filter_sels(X, path = NULL, lspec = FALSE, img.suffix = NULL, it = "jpeg",
 incl.wav = TRUE, missing = FALSE, index = FALSE)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "sel": number of the selections. The output of \code{\link{auto_detec}} can 
be used as the input data frame.}

\item{path}{Character string containing the directory path where the image files are located. 
If \code{NULL} (default) then the current working directory is used.  
\code{\link{warbleR_options}} 'wav.path' argument does not apply.}

\item{lspec}{A logical argument indicating if the image files to be use for filtering were produced by the function \code{\link{full_spectrograms}}. 
All the image files that correspond to a sound file must be deleted in order to be 
filtered out.}

\item{img.suffix}{A character vector of length 1 with the suffix (label) at the end 
of the names of the image files. Default is \code{NULL} (i.e. no suffix as in the images
produced by \code{\link{spectrograms}}). Ignored if \code{lspec = TRUE}.}

\item{it}{A character vector of length 1 giving the image type ("tiff", "jpeg" or "pdf") Default is "jpeg". Note that pdf files can only be generated by \code{\link{lspec2pdf}}.}

\item{incl.wav}{Logical. To indicate if sound files extensions (".wav") are included ( \code{TRUE}, default) or not in the image
file names.}

\item{missing}{Logical. Controls whether the output data frame (or row index if is \code{index = TRUE}) 
contains the selections with images in the working directory (Default, \code{missing = FALSE}) 
or the ones with no image.}

\item{index}{Logical. If \code{TRUE} and \code{missing = FALSE} the row index for the selections with images in the working directory is returned. If \code{missing = TRUE}) then the row index of the ones with no image is returned instead. Default is \code{FALSE}.}
}
\value{
If all .wav files are ok, returns message "All files are ok!".
  Otherwise returns "These file(s) cannot be read" message with names of the
  corrupted .wav files.
}
\description{
\code{filter_sels} subsets selection data frames based on image files that have been manually filtered.
}
\details{
This function subsets selections (or sound files if \code{lspec} is \code{TRUE}) listed in a data frame
 based on the image files from spectrogram-creating functions (e.g. \code{\link{spectrograms}}) in the 
 working directory. Only the selections/sound files with and image in the working directory will remain. 
 This is useful for excluding selections from undesired signals. Note that the
 image files should be in the working directory (or the directory provided in 'path').
}
\examples{
\dontrun{ 
# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))

spectrograms(lbh_selec_table, flim = c(0, 11), inner.mar = c(4,4.5,2,1), outer.mar = c(4,2,2,1), 
picsize = 2, res = 300, cexlab = 2, mar = 0.05, wl = 300, path = tempdir())

#go to the working directory (tempdir()) and delete some images

#filter selection data frame
fmloc <- filter_sels(X = lbh_selec_table, path = tempdir())

#this data frame does not have the selections corresponding to the images that were deleted
fmloc

#now using lspec images
full_spectrograms(sxrow = 2, rows = 8, pal = reverse.heat.colors, wl = 300, ovlp = 10, 
path = tempdir())

# go to the working directory (tempdir()) and delete lspec 
# images (the ones with several rows of spectrograms)

#filter selection data frame
fmloc2 <- filter_sels(X = lbh_selec_table, lspec = TRUE, 
path = tempdir())

}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
