% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfcc_stats.R
\name{mfcc_stats}
\alias{mfcc_stats}
\title{Calculate descriptive statistics on Mel-frequency cepstral coefficients}
\usage{
mfcc_stats(X, ovlp = 50, wl = 512, bp = 'frange', path = NULL, numcep = 25, 
nbands = 40, parallel = 1, pb = TRUE, ...)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' or data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "sel": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The output of \code{\link{manualoc}} or \code{\link{autodetec}} can
be used as the input data frame.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows. Internally this is used to set the 'hoptime' argument in \code{\link[tuneR]{melfcc}}. Default is 50.}

\item{wl}{A numeric vector of length 1 specifying the spectrogram window length. Default is 512. See 'wl.freq' for setting windows length independently in the frequency domain.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) or "frange" (default) to indicate that values in minimum of 'bottom.freq'
and maximum of 'top.freq' columns will be used as bandpass limits.}

\item{path}{Character string containing the directory path where the sound files are located.}

\item{numcep}{Numeric vector of length 1 controlling the number of cepstra to 
return (see \code{\link[tuneR]{melfcc}}).}

\item{nbands}{Numeric vector of length 1 controlling the number of warped spectral bands to use (see \code{\link[tuneR]{melfcc}}). Default is 40.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{...}{Additional parameters to be passed to \code{\link[tuneR]{melfcc}}.}
}
\value{
A data frame containing the descriptive statistics for each of the Mel-frequency 
cepstral coefficients (set by 'numcep' argument). See details.
}
\description{
\code{mfcc_stats} calculates descriptive statistics on Mel-frequency cepstral coefficients and its derivatives.
}
\details{
The function calculates descriptive statistics on Mel-frequency cepstral coefficients (MFCCs) for each of the signals (rows) in a selection
data frame. The descriptive statistics are: minimum, maximum, mean, median, skewness, kurtosis and
variance. 
It also returns the mean and variance for the first and second derivatives of the coefficients. These parameters are commonly used in acoustic signal processing and detection (e.g. Salamon et al 2014).
}
\examples{
{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

# run function
mel_st <- mfcc_stats(X = lbh_selec_table, pb = FALSE, path = tempdir())

head(mel_st)

# measure 12 coefficients 
mel_st12 <- mfcc_stats(X = lbh_selec_table, numcep = 12, pb = FALSE, path = tempdir())

 head(mel_st)
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.

Lyon, R. H., & Ordubadi, A. (1982). Use of cepstra in acoustical signal analysis. Journal of Mechanical Design, 104(2), 303-306.

Salamon, J., Jacoby, C., & Bello, J. P. (2014). A dataset and taxonomy for urban sound research. In Proceedings of the 22nd ACM international conference on Multimedia. 1041-1044.
}
}
\seealso{
\code{\link{fixwavs}}, \code{\link{rm_sil}},
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
