% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp.en.ts.R
\name{sp.en.ts}
\alias{sp.en.ts}
\title{Extract the spectral entropy across signals as a time series}
\usage{
sp.en.ts(X, wl = 512, length.out = 20, wn = "hanning", ovlp = 70, bp = "frange",
  threshold = 15, img = TRUE, parallel = 1, path = NULL, img.suffix = "sp.en.ts",
   pb = TRUE, clip.edges = FALSE, leglab = "sp.en.ts", sp.en.range = c(2, 10), ...)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data 
frame containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signal (start and end).
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can  also be used as the input data frame.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512. Note that this is particularly important for measuring spectral entropy. Low values (~100) 
generate a very detail contour of the variation in spectral entropy that is probably not useful for 
assesing signal similarity.}

\item{length.out}{A character vector of length 1 giving the number of measurements of spectral entropy 
desired (the length of the time series).}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz). If 'frange' (default) then the
'bottom.freq' and 'top.freq' columns are used bandpass limits.}

\item{threshold}{amplitude threshold (\%) for dominant frequency detection. Default is 15.}

\item{img}{Logical argument. If \code{FALSE}, image files are not produced. Default is \code{TRUE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located.}

\item{img.suffix}{A character vector of length 1 with a sufix (label) to add at the end of the names of 
image files.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{clip.edges}{Logical argument to control whether edges (start or end of signal) in
which amplitude values above the threshold were not detected will be removed. If 
\code{TRUE} this edges will be excluded and signal contour will be calculated on the
remainging values. Default is \code{FALSE}.}

\item{leglab}{A character vector of length 1 or 2 containing the label(s) of the frequency contour legend 
in the output image.}

\item{sp.en.range}{Numeric vector of length 2. Range of frequency in which to display the entropy values 
on the spectrogram (when img = TRUE). Default is c(2, 10). Negative values can be used in order to stretch more
the range.}

\item{...}{Additional arguments to be passed to \code{\link{trackfreqs}} for customizing
graphical output.}
}
\value{
A data frame with the dominant frequency values measured across the signals. If img is 
\code{TRUE} it also produces image files with the spectrograms of the signals listed in the 
input data frame showing the location of the dominant frequencies 
(see \code{\link{trackfreqs}} description for more details).
}
\description{
\code{sp.en.ts} spectral entropy across signals as a time series.
of signals selected by \code{\link{manualoc}} or \code{\link{sp.en.ts}}.
}
\details{
This function spectral entropy across signals as a time series. 
The function uses the \code{\link[stats]{approx}} function to interpolate values between spectral 
entropy measures (calculated with \code{\link[seewave]{csh}}). If there are no frequencies above the amplitude theshold 
at the begining or end  of the signals then NAs will be generated. On the other hand, 
if there are no frequenciesabove the amplitude theshold in between signal segments in which amplitude was 
 detected then the values of this adjacent segments will be interpolated 
 to fill out the missing values (e.g. no NAs in between detected amplitude segments). Missing values at the start
 of end can be removed with "clip.edges".
}
\examples{
{
#load data
data(list = c("Phae.long1", "Phae.long2",  "Phae.long3",  "Phae.long4","lbh_selec_table"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav")) #save sound files 
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long3, file.path(tempdir(), "Phae.long3.wav")) #save sound files 
writeWave(Phae.long4, file.path(tempdir(), "Phae.long4.wav"))

# without clip edges
sp.en.ts(X = lbh_selec_table, threshold = 10, clip.edges = FALSE, length.out = 10,
 type = "b", sp.en.range = c(-25, 10), path = tempdir())

# with clip edges and length.out 10
sp.en.ts(X = lbh_selec_table, threshold = 10, bp = c(2, 12), clip.edges = TRUE, length.out = 10, 
path = tempdir())

}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{specreator}} for creating spectrograms from selections,
 \code{\link{snrspecs}} for creating spectrograms to 
  optimize noise margins used in \code{\link{sig2noise}}

Other spectrogram creators: \code{\link{color.spectro}},
  \code{\link{dfDTW}}, \code{\link{dfts}},
  \code{\link{ffDTW}}, \code{\link{ffts}},
  \code{\link{multi_DTW}}, \code{\link{phylo_spectro}},
  \code{\link{snrspecs}}, \code{\link{specreator}},
  \code{\link{trackfreqs}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
\concept{spectrogram creators}
