% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xfer_userEnvs.R
\name{xfer_userEnvs}
\alias{xfer_userEnvs}
\title{xfer_userEnvs Transfer model to user specified area and time}
\usage{
xfer_userEnvs(
  evalOut,
  curModel,
  envs,
  xfExt,
  alg,
  outputType = NULL,
  clamp = NULL,
  logger = NULL,
  spN = NULL
)
}
\arguments{
\item{evalOut}{ENMevaluate output from previous module and using any of the
available algorithms.}

\item{curModel}{if algorithm is maxent, model selected by user as best or
optimal, in terms of feature class and regularization multiplier (e.g
'L_1'). Otherwise it must be 1.}

\item{envs}{user provided environmental layers (in raster format) to be
used for transferring.}

\item{xfExt}{extent of the area to transfer the model. This must be provided
by the user as a shapefile or as a SpatialPolygons object.}

\item{alg}{modeling algorithm used in the model component. Can be one of:
'BIOCLIM', 'maxent.jar' or 'maxnet'.}

\item{outputType}{output type to be used when algorithm is maxnet or
maxent.jar.}

\item{clamp}{logical. Whether transfer will be of clamped or unclamped
model.}

\item{logger}{Stores all notification messages to be displayed in the Log
Window of Wallace GUI. Insert the logger reactive list here for running in
shiny, otherwise leave the default NULL.}

\item{spN}{character. Used to obtain species name for logger messages.}
}
\description{
The function transfers the model generated in previous components
  to user uploaded environmental variables.
}
\details{
This functions allows transferring the model created in previous
  components to a new time and area provided by the user. The transferring
  time and area is user-provided. The model will be transferred to the new
  time and area as long as the environmental variables provided are
  available for the area and match the variables used for model building.
  This function returns a list including the cropped environmental variables
  used for transferring and the transferred model.
}
\examples{
\dontrun{
## extent to transfer
# set coordinates
longitude <- c(-71.58400, -78.81300, -79.34034, -69.83331, -66.47149, -66.71319,
               -71.11931)
latitude <- c(13.18379, 7.52315, 0.93105, -1.70167, 0.98391, 6.09208, 12.74980)
# generate matrix
selCoords <- matrix(c(longitude, latitude), byrow = FALSE, ncol = 2)
polyExt <- sp::SpatialPolygons(list(sp::Polygons(list(sp::Polygon(selCoords)),
                                                 ID = 1)))
# load model
m <- readRDS(system.file("extdata/model.RDS",
                         package = "wallace"))
envsFut <- list.files(path = system.file('extdata/wc/future',
                                         package = "wallace"),
                      full.names = TRUE)
envsFut <- raster::stack(envsFut)
### run function
modXfer <- xfer_userEnvs(evalOut = m, curModel = 1, envs = envsFut,
                         outputType = "cloglog", alg = "maxent.jar",
                         clamp = FALSE, xfExt = polyExt)
}

}
\seealso{
\code{\link[dismo]{predict}}, \code{\link{xfer_time}}
  \code{\link{xfer_userExtent}}
}
\author{
Jamie Kass <jamie.m.kass@gmail.com>

Andrea Paz <paz.andreita@gmail.com>

Gonzalo E. Pinilla-Buitrago <gepinillab@gmail.com>

Bethany A. Johnson <bjohnso005@citymail.cuny.edu>
}
